##import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

##한글 폰트 깨짐 방지 
from matplotlib import font_manager, rc

font_path = "c:\\windows\\fonts\\malgun.ttf"
font_name = font_manager.FontProperties(fname=font_path).get_name()

rc('font', family=font_name)
###########################################

##차트 크기(단위는 인치로 계산됨)
plt.figure(figsize=(5,4))


## data 분석 자료. 탑승 클래스(1,2,3등급) 별 생존자와 사망자 수 분석 자료 
df = pd.read_csv('../data/titanic.csv', encoding='euc-kr')

df_pclass11 = df[(df.Survived == 1) & (df.Pclass == 1)].count()
df_pclass12 = df[(df.Survived == 1) & (df.Pclass == 2)].count()
df_pclass13 = df[(df.Survived == 1) & (df.Pclass == 3)].count()

df_pclass01 = df[(df.Survived == 0) & (df.Pclass == 1)].count()
df_pclass02 = df[(df.Survived == 0) & (df.Pclass == 2)].count()
df_pclass03 = df[(df.Survived == 0) & (df.Pclass == 3)].count()

x1 = ['first', 'second', 'third']  ## x축이름 리스트 

survived_df = [df_pclass11.Pclass, df_pclass12.Pclass, df_pclass13.Pclass] ## y축 데이터 
dead_df = [df_pclass01.Pclass, df_pclass02.Pclass, df_pclass03.Pclass]  ## y축 데이터 
###############################################################################

## 탑승 클래스 별 생존자와 사망자를 plot으로 표현하기 
plt.plot(x1, survived_df, color='green', linestyle='dotted', marker='o', label='survived')
plt.plot(x1, dead_df, color='orange', marker='s', label='dead')
plt.title('탑승클래스별 생존자와 사망자')  ##차트제목 
plt.xlabel('탑승클래스')  ##x축 이름 
h=plt.ylabel('인\n원') ##y축 이름
h.set_rotation(0) 
plt.legend()

plt.show()
